@extends('layouts.master')
@section('content')
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400..700&family=Open+Sans:ital,wght@0,300..800;1,300..800&family=PT+Sans:ital,wght@0,400;0,700;1,400;1,700&family=Poppins:ital,wght@0,200;0,300;1,200;1,300;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');

        body{
            font-family: "Roboto", sans-serif;
            font-style: normal;
        }
        a{
            text-decoration: none;
        }

        .container{
            max-width: 860px;
            padding: 20px 0;
            margin: auto;

        }
        .first-row{
            border: 5px solid #000;
            padding: 20px 10px;
            background-color: #f9f9f9;
        }
        table,th,td {
            border: 1px solid black;
            border-collapse: collapse;
        }
        .first-table-wrapper{
            display: flex;
            gap: 20px;
            justify-content: center;

        }
        .left-side{
            text-align: center;
        }
        .left-side h2 {
            font-size: 22px;
            width: 266px;
        }
        .left-side a {
            background-color: #000;
            padding: 8px 10px;
            color: #fff;
            display: inline-block;
            border-radius: 4px;
            cursor: pointer;
        }
        .result-table{
            border: 3px solid #000;
            margin-top: 20px;
        }
        .third-table-wrapper{
            display: flex;
            gap: 20px;
            margin-top: 20px;
        }
        .last-table-wrapper{
            margin-top: 20px;
        }
        .sig{
            font-family: "Dancing Script", cursive;
            font-weight: 600;
            text-align: center;
        }
        table tr td{
            padding-left: 5px;
        }
        .bg-gray{
            background-color: #e9e9e9;
        }

    </style>
    <div class="card">
        <div class="card-body">
            <form method="POST" action="{{ route('marks_by_class') }}" class="row">
                @csrf
                
                <div class="form-group col-lg-3 col-md-4 col-sm-6">
                    {{ generateDropdown($exams, 'class="form-control exam_id" id="exam_id" name="exam_id" required', $exam_id, 'Select Exam') }}
                </div>

                <div class="form-group col-lg-3 col-md-4 col-sm-6">
                    {{ generateDropdown($academicYears, 'name="academic_year" class="form-control shift_id" id="shift_id"', $academic_year, "Select Year") }}
                </div>

                <div class="form-group col-lg-3 col-md-4 col-sm-6">
                    {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id" ', $shift_id, "Select Shift") }}
                </div>

                <div class="form-group col-lg-3 col-md-4 col-sm-6">
                    {{ generateDropdown($studentClasses, 'class="form-control student_class" id="student_class" name="student_class_id" required', $student_class_id, "Select Class") }}
                </div>
                
                <div class="form-group col-lg-3 col-md-4 col-sm-6">
                    {{ generateDropdown($sections, 'class="form-control section_id" id="section_id" name="section_id" ', $section_id) }}
                </div>

                <div class="form-group col-lg-3 col-md-4 col-sm-6">
                    {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', $group_id, 'Select Group') }}
                </div>
                <div class="form-group col-lg-3 col-md-4 col-sm-6">
                    <button type="submit" class="btn btn-info">Search</button>
                </div>
            </form>
        </div>
    </div>

    @if(isset($students) && !$students->isEmpty())
        <div class="card mt-4">
            <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                <h5>Mark Sheet</h5>
                <div>
                    <button class="btn btn-sm btn-primary" onclick="printMarkDiv()">Print</button>
                    {{-- <button class="btn btn-sm btn-primary" onclick="downloadPdf()">Download Pdf</button> --}}
                </div>
            </div>
            
            <div class="card-body table_content">
                @php
                    $grades_str = '';
                    foreach ($grades as $grade){
                        $grades_str .= "<tr>
                                            <td align='center'>$grade->mark_from-$grade->mark_to</td>
                                            <td align='center'>$grade->name</td>
                                            <td align='center'>$grade->remark</td>
                                        </tr>";
                    }
                   
                    $head_marks_array = json_decode($assignedMarksHead->first()->head_marks, true);
                    $head_id_array = array_keys($head_marks_array);
      
                @endphp

                @foreach ($students as $key=>$student)
                    
                    @php
                        $grand_total = 0;
                        $grand_total_obtain = 0;
                        
                        $exam = $exams[$exam_id] ?? "";
                        $section = $sections[$student->section_id] ?? "";
                        $class = $studentClasses[$student->student_class_id] ?? "";
                        $academicYear = $academicYears[$academic_year] ?? "";
                        $examRecords = $student?->examRecords ?? "";
                    @endphp
                    @if ($examRecords->isNotEmpty())
                        <section class="page-section">
                            <div class="container">
                                <div class="first-row">

                                    <div class="first-table-wrapper">
                                        <div class="left-side">
                                            <h2>Jabalunnur Al-Jamiatul Islamia</h2>
                                            {{-- <a href="">Academic Transcript</a> --}}
                                            <div class="first-table-wrapper">
                                                <img src="{{asset('uploads/images/logo-light.png')}}" height="135" width="200" alt="">
                                            </div>
                                        </div>
                                        <div class="middle-side">
                                            <div class="student-information">
                                                <table border="1" width = "180" height="200">
                                                    <tr>
                                                        <th colspan="2" align="center">Student Information</th>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">ID</th>
                                                        <td align="center">{{$student->student_id_no}}</td>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Name</th>
                                                        <td align="center" class="">{{$student->first_name}} {{$student->last_name}}</td>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Session</th>
                                                        <td align="center">{{$academicYear}}</td>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Class</th>
                                                        <td align="center">{{$class}}</td>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Section</th>
                                                        <td align="center">{{$section}}</td>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Roll</th>
                                                        <td align="center">{{$student->class_roll}}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="right-side">
                                            <div class="Grade-referance">
                                                <table border="1" width = "280" height="200">
                                                    <tr>
                                                        <th colspan="3" align="center">Grade Referance</th>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Marks</th>
                                                        <th align="center">Grade</th>
                                                        <th align="center">Comments</th>
                                                    </tr>
                                                    {!!$grades_str!!}
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                        
                                    <div class="second-table-wrapper">
                                        <table class="result-table" width = "800" height="200">
                                        
                                            <tr>
                                                <th rowspan="2">Subject</th>
                                                <th rowspan="2" class="bg-gray">Full <br> Marks</th>
                                                <th colspan="{{count($head_id_array)+2}}" class="text-center">{{$exam}}</th>
                                            </tr>

                                            <tr align="center">
                                                @if (isset($head_id_array))
                                                    @foreach ($markHeads as $head)
                                                        @if (in_array($head->id,$head_id_array))
                                                            <th>{{$head->short_name}}</th>
                                                        @endif
                                                    @endforeach
                                                @endif
                                                <th>Total marks obtained</th>
                                                <th>Heighest marks</th>
                                            </tr>

                                            @foreach ($examRecords as $recoards)
                                                @php
                                                    $full_marks = 0;
                                                    $head_wise_total_obtain = [];
                                                    $total_marks_obtain = 0;
                                                    $head_records_str = '';
                                                    $blank_col_str = '';

                                                    $head_wise_marks_record = json_decode($recoards->head_wise_marks);
                                                    $subject_head_marks = $assignedMarksHead->groupBy('subject_id');
                                                    $head_marks_data = $subject_head_marks[$recoards->subject->id]->first();
                                                    $head_marks_array = json_decode($head_marks_data->head_marks);
                                                
                                                @endphp
                                                <tr align="center">
                                                    <td align="left">{{$recoards->subject->subject_name}}</td>                                                

                                                    @if (isset($head_wise_marks_record))

                                                        @foreach ($markHeads as $head)
                                                            @if (in_array($head->id,$head_id_array))
                                                                @php
                                                                    $full_marks += $head_marks_array->{$head?->id};
                                                                    $head_records_str .= "<td>".($head_wise_marks_record?->{$head?->id} ?? "-")."</td>";
                                                                    $total_marks_obtain += $head_wise_marks_record?->{$head?->id} ?? 0;
                                                                    $blank_col_str .= "<td></td>"
                                                                @endphp
                                                            @endif
                                                        @endforeach

                                                        <td class="bg-gray">{{$full_marks}}</td>
                                                        {!!$head_records_str!!}

                                                        @php 
                                                            $grand_total_obtain += $total_marks_obtain;
                                                            $grand_total += $full_marks;
                                                        @endphp

                                                    @endif

                                                    <td>{{$total_marks_obtain}}</td>
                                                    <td>{{round($recoards?->highest_marks[$recoards?->subject?->id]) ?? ""}}</td>
                                                </tr>
                                            @endforeach
                                            
                                            
                                            <tr align="center">
                                                <td align="left"> <b>Grand Total</b></td>
                                                <td class="bg-gray">{{$grand_total}}</td>
                                                {!!$blank_col_str!!}
                                                <td> <b>{{$grand_total_obtain}}</b></td>
                                                <td></td>
                                            </tr>
                        
                                            @php
                                                $grade_name = "";
                                                $grand_total_percentage = $grand_total_obtain>0 ? (($grand_total_obtain*100)/$grand_total) : 0;
                                                foreach ($grades as $grade){
                                                    if($grade->mark_from<=$grand_total_percentage && $grade->mark_to>=$grand_total_percentage){
                                                        $grade_name = $grade->name;
                                                    }
                                                }
                                            @endphp

                                            <tr align="center">
                                                <td align="left"> <b>Percentage</b> </td>
                                                {{-- <td></td> --}}
                                                {{-- {!!$blank_col_str!!} --}}
                                                <td colspan="{{count($head_id_array)+3}}">
                                                    <b>{{round($grand_total_percentage,2)}}%</b>
                                                </td>
                                                {{-- <td></td> --}}
                                            </tr>
                                            <tr align="center">
                                                <td align="left"><b>Grade</b></td>
                                                {{-- <td></td>
                                                {!!$blank_col_str!!} --}}
                                                <td colspan="{{count($head_id_array)+3}}">
                                                    <b>{{$grade_name}}</b> 
                                                </td>
                                                {{-- <td></td> --}}
                                            </tr>
                                        </table>
                                    </div>
                        
                                    <div class="third-table-wrapper">
                                        <div class="work-information">
                                            <table border="1" width = "300" height="150">
                                            
                                                <tr>
                                                    <td>Working Days</td>
                                                    <td>{{$examRecords[0]?->total_working_days ?? ""}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Present</td>
                                                    <td>{{$examRecords[0]?->present_count ?? ""}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Absent</td>
                                                    <td>{{$examRecords[0]?->absent_count ?? ""}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Remarks</td>
                                                    <td></td>
                                                </tr>
                                                <tr>
                                                    <td>Result Published</td>
                                                    <td>{{$publish_date}}</td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="conduct-info">
                                            <table border="1" width = "480" height="150">
                                            
                                                <tr>
                                                <td>Conduct</td>
                                                <td></td>
                                                </tr>
                                                <tr>
                                                <td>Moral Development</td>
                                                <td></td>
                                                </tr>
                                                <tr>
                                                    <td>Discipline</td>
                                                    <td></td>
                                                </tr>
                                                <tr>
                                                    <td>Hand Writing</td>
                                                    <td></td>
                                                </tr>
                                                <tr>
                                                    <td>General Remark</td>
                                                    <td>Try more for further upliftment</td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                        
                                    <div class="last-table-wrapper">
                                        <table border="1" width = "800" height="50">
                                            <tr>
                                                <th>Class Teacher's Signature</th>
                                                <th>Principle's Signature</th>
                                                <th>Guardian's Signature</th>
                                            </tr>
                                            <tr>
                                                <td class="sig" style="height: 30px"></td>
                                                <td class="sig"></td>
                                                <td class="sig"></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="page-break"></div>
                        </section>                        
                    @endif
                @endforeach
            </div>
            
        </div>
    @endif
@stop


@section('scripts')
    <script>
        // $('.student_class').on('change', function(){
        //     let student_class_id = $('.student_class').val();
        //     getSection(student_class_id);
        // });

        // let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";

        // if(student_class_id!=''){
        //     getSection(student_class_id);
        // }

        // function getSection(student_class_id){
        //     let section_id = "{{ isset($section_id) ? $section_id : '' }}";
        //     if(student_class_id){
        //         $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
        //             let sections = response;
                    
        //             let option = '<option value="">--Select Section--</option>';
        //             for(let i=0;i<sections.length;i++){
        //                 if(sections[i].student_class_id == student_class_id){
        //                     if(section_id==sections[i].id){
        //                         option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
        //                     }else{
        //                         option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
        //                     }
                           
        //                 }
        //             }
        //             $('select.section_id').empty().append(option);
        //         });
        //     }
        // }

        function printMarkDiv(){
            let htmlToPrint = '';
            let divToPrint = document.getElementsByClassName("table_content");
            const newWin = window.open("");

            htmlToPrint = `<style type="text/css" media="print">
                            @page { size: a4; }
                            .hide-btn{
                                visibility: hidden;
                            }
                            @import url('https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400..700&family=Open+Sans:ital,wght@0,300..800;1,300..800&family=PT+Sans:ital,wght@0,400;0,700;1,400;1,700&family=Poppins:ital,wght@0,200;0,300;1,200;1,300;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');

                            body{
                                font-family: "Roboto", sans-serif;
                                font-style: normal;
                            }
                            a{
                                text-decoration: none;
                            }

                            .container{
                                max-width: 860px;
                                padding: 20px 0;
                                margin: auto;

                            }
                            .first-row{
                                border: 5px solid #000;
                                padding: 20px 10px;
                                background-color: #f9f9f9;
                            }
                            table,th,td {
                                border: 1px solid black;
                                border-collapse: collapse;
                            }
                            .first-table-wrapper{
                                display: flex;
                                gap: 20px;
                                justify-content: center;

                            }
                            .left-side{
                                text-align: center;
                            }
                            .left-side h2 {
                                font-size: 22px;
                                width: 266px;
                            }
                            .left-side a {
                                background-color: #000;
                                padding: 8px 10px;
                                color: #fff;
                                display: inline-block;
                                border-radius: 4px;
                                cursor: pointer;
                            }
                            .result-table{
                                border: 3px solid #000;
                                margin-top: 20px;
                            }
                            .third-table-wrapper{
                                display: flex;
                                gap: 20px;
                                margin-top: 20px;
                            }
                            .last-table-wrapper{
                                margin-top: 20px;
                            }
                            .sig{
                                font-family: "Dancing Script", cursive;
                                font-weight: 600;
                                text-align: center;
                            }
                            table tr td{
                                padding-left: 5px;
                            }
                            .bg-gray{
                                background-color: #e9e9e9;
                            }
                            .page-break {
                                page-break-after: always;
                            }
                        </style>`;

            newWin.document.write(htmlToPrint);
            
            newWin.document.write(divToPrint[0].outerHTML);
            newWin.document.close();
            // newWin.print();
            // newWin.close();
            setTimeout(function() {
                newWin.print();
                newWin.close();
            }, 90);
        }

        function downloadPdf(){
            let htmlToPrint = '';
            // let divToPrint = document.getElementsByClassName("table_content");
            htmlToPrint = $('.table_content').html();
            // htmlToPrint += divToPrint;

            const csrfToken = document.head.querySelector('meta[name="csrf-token"]').content;

            $.post("{{ route('marks_sheet_download') }}", {
                _token: csrfToken,
                html_content: htmlToPrint,
            }, function(response) {
                if (response) {
                    
                }
            });
            
        }

    </script>
@endsection